/* JS Beautifier Written by Einar Lielmanis, <einar@jsbeautifier.org> http://jsbeautifier.org/ The MIT License (MIT) Copyright (c) 2007-2013 Einar Lielmanis and contributors. */
Object.values||(Object.values=function(o){if(o!==Object(o))throw new TypeError("Object.values called on a non-object");var p,k=[];for(p in o)Object.prototype.hasOwnProperty.call(o,p)&&k.push(o[p]);return k}),function(){function mergeOpts(allOptions,targetType){var name,finalOpts={};for(name in allOptions)name!==targetType&&(finalOpts[name]=allOptions[name]);if(targetType in allOptions)for(name in allOptions[targetType])finalOpts[name]=allOptions[targetType][name];return finalOpts}function js_beautify(js_source_text,options){function in_array(what,arr){for(var i=0;i<arr.length;i+=1)if(arr[i]===what)return!0;return!1}function trim(s){return s.replace(/^\s+|\s+$/g,"")}function ltrim(s){return s.replace(/^\s+/g,"")}function sanitizeOperatorPosition(opPosition){opPosition=opPosition||OPERATOR_POSITION.before_newline;var validPositionValues=Object.values(OPERATOR_POSITION);if(!in_array(opPosition,validPositionValues))throw new Error("Invalid Option Value: The option 'operator_position' must be one of the following values\n"+validPositionValues+"\nYou passed in: '"+opPosition+"'");return opPosition}function Beautifier(js_source_text,options){"use strict";function create_flags(flags_base,mode){var next_indent_level=0;flags_base&&(next_indent_level=flags_base.indentation_level,!output.just_added_newline()&&flags_base.line_indent_level>next_indent_level&&(next_indent_level=flags_base.line_indent_level));var next_flags={mode:mode,parent:flags_base,last_text:flags_base?flags_base.last_text:"",last_word:flags_base?flags_base.last_word:"",declaration_statement:!1,declaration_assignment:!1,multiline_frame:!1,inline_frame:!1,if_block:!1,else_block:!1,do_block:!1,do_while:!1,import_block:!1,in_case_statement:!1,in_case:!1,case_body:!1,indentation_level:next_indent_level,line_indent_level:flags_base?flags_base.line_indent_level:next_indent_level,start_line_index:output.get_line_number(),ternary_depth:0};return next_flags}function handle_token(local_token){var newlines=local_token.newlines,keep_whitespace=opt.keep_array_indentation&&is_array(flags.mode);if(keep_whitespace)for(var i=0;i<newlines;i+=1)print_newline(i>0);else if(opt.max_preserve_newlines&&newlines>opt.max_preserve_newlines&&(newlines=opt.max_preserve_newlines),opt.preserve_newlines&&local_token.newlines>1){print_newline();for(var j=1;j<newlines;j+=1)print_newline(!0)}current_token=local_token,handlers[current_token.type]()}function split_linebreaks(s){s=s.replace(acorn.allLineBreaks,"\n");for(var out=[],idx=s.indexOf("\n");idx!==-1;)out.push(s.substring(0,idx)),s=s.substring(idx+1),idx=s.indexOf("\n");return s.length&&out.push(s),out}function allow_wrap_or_preserved_newline(force_linewrap){if(force_linewrap=void 0!==force_linewrap&&force_linewrap,!output.just_added_newline()){var shouldPreserveOrForce=opt.preserve_newlines&&current_token.wanted_newline||force_linewrap,operatorLogicApplies=in_array(flags.last_text,Tokenizer.positionable_operators)||in_array(current_token.text,Tokenizer.positionable_operators);if(operatorLogicApplies){var shouldPrintOperatorNewline=in_array(flags.last_text,Tokenizer.positionable_operators)&&in_array(opt.operator_position,OPERATOR_POSITION_BEFORE_OR_PRESERVE)||in_array(current_token.text,Tokenizer.positionable_operators);shouldPreserveOrForce=shouldPreserveOrForce&&shouldPrintOperatorNewline}if(shouldPreserveOrForce)print_newline(!1,!0);else if(opt.wrap_line_length){if("TK_RESERVED"===last_type&&in_array(flags.last_text,newline_restricted_tokens))return;var proposed_line_length=output.current_line.get_character_count()+current_token.text.length+(output.space_before_token?1:0);proposed_line_length>=opt.wrap_line_length&&print_newline(!1,!0)}}}function print_newline(force_newline,preserve_statement_flags){if(!preserve_statement_flags&&";"!==flags.last_text&&","!==flags.last_text&&"="!==flags.last_text&&"TK_OPERATOR"!==last_type)for(var next_token=get_token(1);!(flags.mode!==MODE.Statement||flags.if_block&&next_token&&"TK_RESERVED"===next_token.type&&"else"===next_token.text||flags.do_block);)restore_mode();output.add_new_line(force_newline)&&(flags.multiline_frame=!0)}function print_token_line_indentation(){output.just_added_newline()&&(opt.keep_array_indentation&&is_array(flags.mode)&&current_token.wanted_newline?(output.current_line.push(current_token.whitespace_before),output.space_before_token=!1):output.set_indent(flags.indentation_level)&&(flags.line_indent_level=flags.indentation_level))}function print_token(printable_token){if(output.raw)return void output.add_raw_token(current_token);if(opt.comma_first&&"TK_COMMA"===last_type&&output.just_added_newline()&&","===output.previous_line.last()){var popped=output.previous_line.pop();output.previous_line.is_empty()&&(output.previous_line.push(popped),output.trim(!0),output.current_line.pop(),output.trim()),print_token_line_indentation(),output.add_token(","),output.space_before_token=!0}printable_token=printable_token||current_token.text,print_token_line_indentation(),output.add_token(printable_token)}function indent(){flags.indentation_level+=1}function deindent(){flags.indentation_level>0&&(!flags.parent||flags.indentation_level>flags.parent.indentation_level)&&(flags.indentation_level-=1)}function set_mode(mode){flags?(flag_store.push(flags),previous_flags=flags):previous_flags=create_flags(null,mode),flags=create_flags(previous_flags,mode)}function is_array(mode){return mode===MODE.ArrayLiteral}function is_expression(mode){return in_array(mode,[MODE.Expression,MODE.ForInitializer,MODE.Conditional])}function restore_mode(){flag_store.length>0&&(previous_flags=flags,flags=flag_store.pop(),previous_flags.mode===MODE.Statement&&output.remove_redundant_indentation(previous_flags))}function start_of_object_property(){return flags.parent.mode===MODE.ObjectLiteral&&flags.mode===MODE.Statement&&(":"===flags.last_text&&0===flags.ternary_depth||"TK_RESERVED"===last_type&&in_array(flags.last_text,["get","set"]))}function start_of_statement(){return!!("TK_RESERVED"===last_type&&in_array(flags.last_text,["var","let","const"])&&"TK_WORD"===current_token.type||"TK_RESERVED"===last_type&&"do"===flags.last_text||"TK_RESERVED"===last_type&&in_array(flags.last_text,["return","throw"])&&!current_token.wanted_newline||"TK_RESERVED"===last_type&&"else"===flags.last_text&&("TK_RESERVED"!==current_token.type||"if"!==current_token.text)||"TK_END_EXPR"===last_type&&(previous_flags.mode===MODE.ForInitializer||previous_flags.mode===MODE.Conditional)||"TK_WORD"===last_type&&flags.mode===MODE.BlockStatement&&!flags.in_case&&"--"!==current_token.text&&"++"!==current_token.text&&"function"!==last_last_text&&"TK_WORD"!==current_token.type&&"TK_RESERVED"!==current_token.type||flags.mode===MODE.ObjectLiteral&&(":"===flags.last_text&&0===flags.ternary_depth||"TK_RESERVED"===last_type&&in_array(flags.last_text,["get","set"])))&&(set_mode(MODE.Statement),indent(),"TK_RESERVED"===last_type&&in_array(flags.last_text,["var","let","const"])&&"TK_WORD"===current_token.type&&(flags.declaration_statement=!0),start_of_object_property()||allow_wrap_or_preserved_newline("TK_RESERVED"===current_token.type&&in_array(current_token.text,["do","for","if","while"])),!0)}function all_lines_start_with(lines,c){for(var i=0;i<lines.length;i++){var line=trim(lines[i]);if(line.charAt(0)!==c)return!1}return!0}function each_line_matches_indent(lines,indent){for(var line,i=0,len=lines.length;i<len;i++)if(line=lines[i],line&&0!==line.indexOf(indent))return!1;return!0}function is_special_word(word){return in_array(word,["case","return","do","if","throw","else"])}function get_token(offset){var index=token_pos+(offset||0);return index<0||index>=tokens.length?null:tokens[index]}function handle_start_expr(){start_of_statement();var next_mode=MODE.Expression;if("["===current_token.text){if("TK_WORD"===last_type||")"===flags.last_text)return"TK_RESERVED"===last_type&&in_array(flags.last_text,Tokenizer.line_starters)&&(output.space_before_token=!0),set_mode(next_mode),print_token(),indent(),void(opt.space_in_paren&&(output.space_before_token=!0));next_mode=MODE.ArrayLiteral,is_array(flags.mode)&&("["!==flags.last_text&&(","!==flags.last_text||"]"!==last_last_text&&"}"!==last_last_text)||opt.keep_array_indentation||print_newline())}else"TK_RESERVED"===last_type&&"for"===flags.last_text?next_mode=MODE.ForInitializer:"TK_RESERVED"===last_type&&in_array(flags.last_text,["if","while"])&&(next_mode=MODE.Conditional);";"===flags.last_text||"TK_START_BLOCK"===last_type?print_newline():"TK_END_EXPR"===last_type||"TK_START_EXPR"===last_type||"TK_END_BLOCK"===last_type||"."===flags.last_text?allow_wrap_or_preserved_newline(current_token.wanted_newline):"TK_RESERVED"===last_type&&"("===current_token.text||"TK_WORD"===last_type||"TK_OPERATOR"===last_type?"TK_RESERVED"===last_type&&("function"===flags.last_word||"typeof"===flags.last_word)||"*"===flags.last_text&&(in_array(last_last_text,["function","yield"])||flags.mode===MODE.ObjectLiteral&&in_array(last_last_text,["{",","]))?opt.space_after_anon_function&&(output.space_before_token=!0):"TK_RESERVED"!==last_type||!in_array(flags.last_text,Tokenizer.line_starters)&&"catch"!==flags.last_text||opt.space_before_conditional&&(output.space_before_token=!0):output.space_before_token=!0,"("===current_token.text&&"TK_RESERVED"===last_type&&"await"===flags.last_word&&(output.space_before_token=!0),"("===current_token.text&&("TK_EQUALS"!==last_type&&"TK_OPERATOR"!==last_type||start_of_object_property()||allow_wrap_or_preserved_newline()),"("===current_token.text&&"TK_WORD"!==last_type&&"TK_RESERVED"!==last_type&&allow_wrap_or_preserved_newline(),set_mode(next_mode),print_token(),opt.space_in_paren&&(output.space_before_token=!0),indent()}function handle_end_expr(){for(;flags.mode===MODE.Statement;)restore_mode();flags.multiline_frame&&allow_wrap_or_preserved_newline("]"===current_token.text&&is_array(flags.mode)&&!opt.keep_array_indentation),opt.space_in_paren&&("TK_START_EXPR"!==last_type||opt.space_in_empty_paren?output.space_before_token=!0:(output.trim(),output.space_before_token=!1)),"]"===current_token.text&&opt.keep_array_indentation?(print_token(),restore_mode()):(restore_mode(),print_token()),output.remove_redundant_indentation(previous_flags),flags.do_while&&previous_flags.mode===MODE.Conditional&&(previous_flags.mode=MODE.Expression,flags.do_block=!1,flags.do_while=!1)}function handle_start_block(){var next_token=get_token(1),second_token=get_token(2);set_mode(second_token&&(in_array(second_token.text,[":",","])&&in_array(next_token.type,["TK_STRING","TK_WORD","TK_RESERVED"])||in_array(next_token.text,["get","set","..."])&&in_array(second_token.type,["TK_WORD","TK_RESERVED"]))?in_array(last_last_text,["class","interface"])?MODE.BlockStatement:MODE.ObjectLiteral:"TK_OPERATOR"===last_type&&"=>"===flags.last_text?MODE.BlockStatement:in_array(last_type,["TK_EQUALS","TK_START_EXPR","TK_COMMA","TK_OPERATOR"])||"TK_RESERVED"===last_type&&in_array(flags.last_text,["return","throw","import","default"])?MODE.ObjectLiteral:MODE.BlockStatement);var empty_braces=!next_token.comments_before.length&&"}"===next_token.text,empty_anonymous_function=empty_braces&&"function"===flags.last_word&&"TK_END_EXPR"===last_type;if(opt.brace_preserve_inline){var index=0,check_token=null;flags.inline_frame=!0;do if(index+=1,check_token=get_token(index),check_token.wanted_newline){flags.inline_frame=!1;break}while("TK_EOF"!==check_token.type&&("TK_END_BLOCK"!==check_token.type||check_token.opened!==current_token))}("expand"===opt.brace_style||"none"===opt.brace_style&&current_token.wanted_newline)&&!flags.inline_frame?"TK_OPERATOR"!==last_type&&(empty_anonymous_function||"TK_EQUALS"===last_type||"TK_RESERVED"===last_type&&is_special_word(flags.last_text)&&"else"!==flags.last_text)?output.space_before_token=!0:print_newline(!1,!0):(!is_array(previous_flags.mode)||"TK_START_EXPR"!==last_type&&"TK_COMMA"!==last_type||(("TK_COMMA"===last_type||opt.space_in_paren)&&(output.space_before_token=!0),("TK_COMMA"===last_type||"TK_START_EXPR"===last_type&&flags.inline_frame)&&(allow_wrap_or_preserved_newline(),previous_flags.multiline_frame=previous_flags.multiline_frame||flags.multiline_frame,flags.multiline_frame=!1)),"TK_OPERATOR"!==last_type&&"TK_START_EXPR"!==last_type&&("TK_START_BLOCK"!==last_type||flags.inline_frame?output.space_before_token=!0:print_newline())),print_token(),indent()}function handle_end_block(){for(;flags.mode===MODE.Statement;)restore_mode();var empty_braces="TK_START_BLOCK"===last_type;flags.inline_frame&&!empty_braces?output.space_before_token=!0:"expand"===opt.brace_style?empty_braces||print_newline():empty_braces||(is_array(flags.mode)&&opt.keep_array_indentation?(opt.keep_array_indentation=!1,print_newline(),opt.keep_array_indentation=!0):print_newline()),restore_mode(),print_token()}function handle_word(){if("TK_RESERVED"===current_token.type)if(in_array(current_token.text,["set","get"])&&flags.mode!==MODE.ObjectLiteral)current_token.type="TK_WORD";else if(in_array(current_token.text,["as","from"])&&!flags.import_block)current_token.type="TK_WORD";else if(flags.mode===MODE.ObjectLiteral){var next_token=get_token(1);":"===next_token.text&&(current_token.type="TK_WORD")}if(start_of_statement()||!current_token.wanted_newline||is_expression(flags.mode)||"TK_OPERATOR"===last_type&&"--"!==flags.last_text&&"++"!==flags.last_text||"TK_EQUALS"===last_type||!opt.preserve_newlines&&"TK_RESERVED"===last_type&&in_array(flags.last_text,["var","let","const","set","get"])||print_newline(),flags.do_block&&!flags.do_while){if("TK_RESERVED"===current_token.type&&"while"===current_token.text)return output.space_before_token=!0,print_token(),output.space_before_token=!0,void(flags.do_while=!0);print_newline(),flags.do_block=!1}if(flags.if_block)if(flags.else_block||"TK_RESERVED"!==current_token.type||"else"!==current_token.text){for(;flags.mode===MODE.Statement;)restore_mode();flags.if_block=!1,flags.else_block=!1}else flags.else_block=!0;if("TK_RESERVED"===current_token.type&&("case"===current_token.text||"default"===current_token.text&&flags.in_case_statement))return print_newline(),(flags.case_body||opt.jslint_happy)&&(deindent(),flags.case_body=!1),print_token(),flags.in_case=!0,void(flags.in_case_statement=!0);if("TK_COMMA"!==last_type&&"TK_START_EXPR"!==last_type&&"TK_EQUALS"!==last_type&&"TK_OPERATOR"!==last_type||start_of_object_property()||allow_wrap_or_preserved_newline(),"TK_RESERVED"===current_token.type&&"function"===current_token.text)return(in_array(flags.last_text,["}",";"])||output.just_added_newline()&&!in_array(flags.last_text,["(","[","{",":","=",","])&&"TK_OPERATOR"!==last_type)&&(output.just_added_blankline()||current_token.comments_before.length||(print_newline(),print_newline(!0))),"TK_RESERVED"===last_type||"TK_WORD"===last_type?"TK_RESERVED"===last_type&&in_array(flags.last_text,["get","set","new","return","export","async"])?output.space_before_token=!0:"TK_RESERVED"===last_type&&"default"===flags.last_text&&"export"===last_last_text?output.space_before_token=!0:print_newline():"TK_OPERATOR"===last_type||"="===flags.last_text?output.space_before_token=!0:(flags.multiline_frame||!is_expression(flags.mode)&&!is_array(flags.mode))&&print_newline(),print_token(),void(flags.last_word=current_token.text);if(prefix="NONE","TK_END_BLOCK"===last_type?previous_flags.inline_frame?prefix="SPACE":"TK_RESERVED"===current_token.type&&in_array(current_token.text,["else","catch","finally","from"])?"expand"===opt.brace_style||"end-expand"===opt.brace_style||"none"===opt.brace_style&&current_token.wanted_newline?prefix="NEWLINE":(prefix="SPACE",output.space_before_token=!0):prefix="NEWLINE":"TK_SEMICOLON"===last_type&&flags.mode===MODE.BlockStatement?prefix="NEWLINE":"TK_SEMICOLON"===last_type&&is_expression(flags.mode)?prefix="SPACE":"TK_STRING"===last_type?prefix="NEWLINE":"TK_RESERVED"===last_type||"TK_WORD"===last_type||"*"===flags.last_text&&(in_array(last_last_text,["function","yield"])||flags.mode===MODE.ObjectLiteral&&in_array(last_last_text,["{",","]))?prefix="SPACE":"TK_START_BLOCK"===last_type?prefix=flags.inline_frame?"SPACE":"NEWLINE":"TK_END_EXPR"===last_type&&(output.space_before_token=!0,prefix="NEWLINE"),"TK_RESERVED"===current_token.type&&in_array(current_token.text,Tokenizer.line_starters)&&")"!==flags.last_text&&(prefix=flags.inline_frame||"else"===flags.last_text||"export"===flags.last_text?"SPACE":"NEWLINE"),"TK_RESERVED"===current_token.type&&in_array(current_token.text,["else","catch","finally"]))if(("TK_END_BLOCK"!==last_type||previous_flags.mode!==MODE.BlockStatement||"expand"===opt.brace_style||"end-expand"===opt.brace_style||"none"===opt.brace_style&&current_token.wanted_newline)&&!flags.inline_frame)print_newline();else{output.trim(!0);var line=output.current_line;"}"!==line.last()&&print_newline(),output.space_before_token=!0}else"NEWLINE"===prefix?"TK_RESERVED"===last_type&&is_special_word(flags.last_text)?output.space_before_token=!0:"TK_END_EXPR"!==last_type?"TK_START_EXPR"===last_type&&"TK_RESERVED"===current_token.type&&in_array(current_token.text,["var","let","const"])||":"===flags.last_text||("TK_RESERVED"===current_token.type&&"if"===current_token.text&&"else"===flags.last_text?output.space_before_token=!0:print_newline()):"TK_RESERVED"===current_token.type&&in_array(current_token.text,Tokenizer.line_starters)&&")"!==flags.last_text&&print_newline():flags.multiline_frame&&is_array(flags.mode)&&","===flags.last_text&&"}"===last_last_text?print_newline():"SPACE"===prefix&&(output.space_before_token=!0);print_token(),flags.last_word=current_token.text,"TK_RESERVED"===current_token.type&&("do"===current_token.text?flags.do_block=!0:"if"===current_token.text?flags.if_block=!0:"import"===current_token.text?flags.import_block=!0:flags.import_block&&"TK_RESERVED"===current_token.type&&"from"===current_token.text&&(flags.import_block=!1))}function handle_semicolon(){start_of_statement()&&(output.space_before_token=!1);for(var next_token=get_token(1);!(flags.mode!==MODE.Statement||flags.if_block&&next_token&&"TK_RESERVED"===next_token.type&&"else"===next_token.text||flags.do_block);)restore_mode();flags.import_block&&(flags.import_block=!1),print_token()}function handle_string(){start_of_statement()?output.space_before_token=!0:"TK_RESERVED"===last_type||"TK_WORD"===last_type||flags.inline_frame?output.space_before_token=!0:"TK_COMMA"===last_type||"TK_START_EXPR"===last_type||"TK_EQUALS"===last_type||"TK_OPERATOR"===last_type?start_of_object_property()||allow_wrap_or_preserved_newline():print_newline(),print_token()}function handle_equals(){start_of_statement(),flags.declaration_statement&&(flags.declaration_assignment=!0),output.space_before_token=!0,print_token(),output.space_before_token=!0}function handle_comma(){print_token(),output.space_before_token=!0,flags.declaration_statement?(is_expression(flags.parent.mode)&&(flags.declaration_assignment=!1),flags.declaration_assignment?(flags.declaration_assignment=!1,print_newline(!1,!0)):opt.comma_first&&allow_wrap_or_preserved_newline()):flags.mode===MODE.ObjectLiteral||flags.mode===MODE.Statement&&flags.parent.mode===MODE.ObjectLiteral?(flags.mode===MODE.Statement&&restore_mode(),flags.inline_frame||print_newline()):opt.comma_first&&allow_wrap_or_preserved_newline()}function handle_operator(){if(start_of_statement(),"TK_RESERVED"===last_type&&is_special_word(flags.last_text))return output.space_before_token=!0,void print_token();if("*"===current_token.text&&"TK_DOT"===last_type)return void print_token();if("::"===current_token.text)return void print_token();if("TK_OPERATOR"===last_type&&in_array(opt.operator_position,OPERATOR_POSITION_BEFORE_OR_PRESERVE)&&allow_wrap_or_preserved_newline(),":"===current_token.text&&flags.in_case)return flags.case_body=!0,indent(),print_token(),print_newline(),void(flags.in_case=!1);var space_before=!0,space_after=!0,in_ternary=!1,isGeneratorAsterisk="*"===current_token.text&&("TK_RESERVED"===last_type&&in_array(flags.last_text,["function","yield"])||flags.mode===MODE.ObjectLiteral&&in_array(last_type,["TK_START_BLOCK","TK_COMMA"])||flags.mode===MODE.BlockStatement&&in_array(last_type,["TK_START_BLOCK","TK_COMMA","TK_END_BLOCK","TK_SEMICOLON"])),isUnary=in_array(current_token.text,["-","+"])&&(in_array(last_type,["TK_START_BLOCK","TK_START_EXPR","TK_EQUALS","TK_OPERATOR"])||in_array(flags.last_text,Tokenizer.line_starters)||","===flags.last_text);if(":"===current_token.text?0===flags.ternary_depth?space_before=!1:(flags.ternary_depth-=1,in_ternary=!0):"?"===current_token.text&&(flags.ternary_depth+=1),!isUnary&&!isGeneratorAsterisk&&opt.preserve_newlines&&in_array(current_token.text,Tokenizer.positionable_operators)){var isColon=":"===current_token.text,isTernaryColon=isColon&&in_ternary,isOtherColon=isColon&&!in_ternary;switch(opt.operator_position){case OPERATOR_POSITION.before_newline:return output.space_before_token=!isOtherColon,print_token(),isColon&&!isTernaryColon||allow_wrap_or_preserved_newline(),void(output.space_before_token=!0);case OPERATOR_POSITION.after_newline:return output.space_before_token=!0,!isColon||isTernaryColon?get_token(1).wanted_newline?print_newline(!1,!0):allow_wrap_or_preserved_newline():output.space_before_token=!1,print_token(),void(output.space_before_token=!0);case OPERATOR_POSITION.preserve_newline:return isOtherColon||allow_wrap_or_preserved_newline(),space_before=!(output.just_added_newline()||isOtherColon),output.space_before_token=space_before,print_token(),void(output.space_before_token=!0)}}if(isGeneratorAsterisk){allow_wrap_or_preserved_newline(),space_before=!1;var next_token=get_token(1);space_after=next_token&&in_array(next_token.type,["TK_WORD","TK_RESERVED"])}else"..."===current_token.text?(allow_wrap_or_preserved_newline(),space_before="TK_START_BLOCK"===last_type,space_after=!1):(in_array(current_token.text,["--","++","!","~"])||isUnary)&&(space_before=!1,space_after=!1,!current_token.wanted_newline||"--"!==current_token.text&&"++"!==current_token.text||print_newline(!1,!0),";"===flags.last_text&&is_expression(flags.mode)&&(space_before=!0),"TK_RESERVED"===last_type?space_before=!0:"TK_END_EXPR"===last_type?space_before=!("]"===flags.last_text&&("--"===current_token.text||"++"===current_token.text)):"TK_OPERATOR"===last_type&&(space_before=in_array(current_token.text,["--","-","++","+"])&&in_array(flags.last_text,["--","-","++","+"]),in_array(current_token.text,["+","-"])&&in_array(flags.last_text,["--","++"])&&(space_after=!0)),(flags.mode!==MODE.BlockStatement||flags.inline_frame)&&flags.mode!==MODE.Statement||"{"!==flags.last_text&&";"!==flags.last_text||print_newline());output.space_before_token=output.space_before_token||space_before,print_token(),output.space_before_token=space_after}function handle_block_comment(){if(output.raw)return output.add_raw_token(current_token),void(current_token.directives&&"end"===current_token.directives.preserve&&(output.raw=opt.test_output_raw));if(current_token.directives)return print_newline(!1,!0),print_token(),"start"===current_token.directives.preserve&&(output.raw=!0),void print_newline(!1,!0);if(!acorn.newline.test(current_token.text)&&!current_token.wanted_newline)return output.space_before_token=!0,print_token(),void(output.space_before_token=!0);var j,lines=split_linebreaks(current_token.text),javadoc=!1,starless=!1,lastIndent=current_token.whitespace_before,lastIndentLength=lastIndent.length;for(print_newline(!1,!0),lines.length>1&&(javadoc=all_lines_start_with(lines.slice(1),"*"),starless=each_line_matches_indent(lines.slice(1),lastIndent)),print_token(lines[0]),j=1;j<lines.length;j++)print_newline(!1,!0),javadoc?print_token(" "+ltrim(lines[j])):starless&&lines[j].length>lastIndentLength?print_token(lines[j].substring(lastIndentLength)):output.add_token(lines[j]);print_newline(!1,!0)}function handle_comment(){current_token.wanted_newline?print_newline(!1,!0):output.trim(!0),output.space_before_token=!0,print_token(),print_newline(!1,!0)}function handle_dot(){start_of_statement(),"TK_RESERVED"===last_type&&is_special_word(flags.last_text)?output.space_before_token=!0:allow_wrap_or_preserved_newline(")"===flags.last_text&&opt.break_chained_methods),print_token()}function handle_unknown(){print_token(),"\n"===current_token.text[current_token.text.length-1]&&print_newline()}function handle_eof(){for(;flags.mode===MODE.Statement;)restore_mode()}var output,token_pos,Tokenizer,current_token,last_type,last_last_text,indent_string,flags,previous_flags,flag_store,prefix,handlers,opt,tokens=[],baseIndentString="";handlers={TK_START_EXPR:handle_start_expr,TK_END_EXPR:handle_end_expr,TK_START_BLOCK:handle_start_block,TK_END_BLOCK:handle_end_block,TK_WORD:handle_word,TK_RESERVED:handle_word,TK_SEMICOLON:handle_semicolon,TK_STRING:handle_string,TK_EQUALS:handle_equals,TK_OPERATOR:handle_operator,TK_COMMA:handle_comma,TK_BLOCK_COMMENT:handle_block_comment,TK_COMMENT:handle_comment,TK_DOT:handle_dot,TK_UNKNOWN:handle_unknown,TK_EOF:handle_eof},options=options?options:{},options=mergeOpts(options,"js"),opt={},"expand-strict"===options.brace_style?options.brace_style="expand":"collapse-preserve-inline"===options.brace_style?options.brace_style="collapse,preserve-inline":void 0!==options.braces_on_own_line?options.brace_style=options.braces_on_own_line?"expand":"collapse":options.brace_style||(options.brace_style="collapse");var brace_style_split=options.brace_style.split(/[^a-zA-Z0-9_\-]+/);for(opt.brace_style=brace_style_split[0],opt.brace_preserve_inline=!!brace_style_split[1]&&brace_style_split[1],opt.indent_size=options.indent_size?parseInt(options.indent_size,10):4,opt.indent_char=options.indent_char?options.indent_char:" ",opt.eol=options.eol?options.eol:"auto",opt.preserve_newlines=void 0===options.preserve_newlines||options.preserve_newlines,opt.break_chained_methods=void 0!==options.break_chained_methods&&options.break_chained_methods,opt.max_preserve_newlines=void 0===options.max_preserve_newlines?0:parseInt(options.max_preserve_newlines,10),opt.space_in_paren=void 0!==options.space_in_paren&&options.space_in_paren,opt.space_in_empty_paren=void 0!==options.space_in_empty_paren&&options.space_in_empty_paren,opt.jslint_happy=void 0!==options.jslint_happy&&options.jslint_happy,opt.space_after_anon_function=void 0!==options.space_after_anon_function&&options.space_after_anon_function,opt.keep_array_indentation=void 0!==options.keep_array_indentation&&options.keep_array_indentation,opt.space_before_conditional=void 0===options.space_before_conditional||options.space_before_conditional,opt.unescape_strings=void 0!==options.unescape_strings&&options.unescape_strings,opt.wrap_line_length=void 0===options.wrap_line_length?0:parseInt(options.wrap_line_length,10),opt.e4x=void 0!==options.e4x&&options.e4x,opt.end_with_newline=void 0!==options.end_with_newline&&options.end_with_newline,opt.comma_first=void 0!==options.comma_first&&options.comma_first,opt.operator_position=sanitizeOperatorPosition(options.operator_position),opt.test_output_raw=void 0!==options.test_output_raw&&options.test_output_raw,opt.jslint_happy&&(opt.space_after_anon_function=!0),options.indent_with_tabs&&(opt.indent_char="\t",opt.indent_size=1),"auto"===opt.eol&&(opt.eol="\n",js_source_text&&acorn.lineBreak.test(js_source_text||"")&&(opt.eol=js_source_text.match(acorn.lineBreak)[0])),opt.eol=opt.eol.replace(/\\r/,"\r").replace(/\\n/,"\n"),indent_string="";opt.indent_size>0;)indent_string+=opt.indent_char,opt.indent_size-=1;var preindent_index=0;if(js_source_text&&js_source_text.length){for(;" "===js_source_text.charAt(preindent_index)||"\t"===js_source_text.charAt(preindent_index);)baseIndentString+=js_source_text.charAt(preindent_index),preindent_index+=1;js_source_text=js_source_text.substring(preindent_index)}last_type="TK_START_BLOCK",last_last_text="",output=new Output(indent_string,baseIndentString),output.raw=opt.test_output_raw,flag_store=[],set_mode(MODE.BlockStatement),this.beautify=function(){function get_local_token(){return local_token=get_token()}var local_token,sweet_code;for(Tokenizer=new tokenizer(js_source_text,opt,indent_string),tokens=Tokenizer.tokenize(),token_pos=0;get_local_token();){for(var i=0;i<local_token.comments_before.length;i++)handle_token(local_token.comments_before[i]);handle_token(local_token),last_last_text=flags.last_text,last_type=local_token.type,flags.last_text=local_token.text,token_pos+=1}return sweet_code=output.get_code(),opt.end_with_newline&&(sweet_code+="\n"),"\n"!==opt.eol&&(sweet_code=sweet_code.replace(/[\n]/g,opt.eol)),sweet_code};var newline_restricted_tokens=["break","continue","return","throw"]}function OutputLine(parent){var _character_count=0,_indent_count=-1,_items=[],_empty=!0;this.set_indent=function(level){_character_count=parent.baseIndentLength+level*parent.indent_length,_indent_count=level},this.get_character_count=function(){return _character_count},this.is_empty=function(){return _empty},this.last=function(){return this._empty?null:_items[_items.length-1]},this.push=function(input){_items.push(input),_character_count+=input.length,_empty=!1},this.pop=function(){var item=null;return _empty||(item=_items.pop(),_character_count-=item.length,_empty=0===_items.length),item},this.remove_indent=function(){_indent_count>0&&(_indent_count-=1,_character_count-=parent.indent_length)},this.trim=function(){for(;" "===this.last();)_items.pop(),_character_count-=1;_empty=0===_items.length},this.toString=function(){var result="";return this._empty||(_indent_count>=0&&(result=parent.indent_cache[_indent_count]),result+=_items.join("")),result}}function Output(indent_string,baseIndentString){baseIndentString=baseIndentString||"",this.indent_cache=[baseIndentString],this.baseIndentLength=baseIndentString.length,this.indent_length=indent_string.length,this.raw=!1;var lines=[];this.baseIndentString=baseIndentString,this.indent_string=indent_string,this.previous_line=null,this.current_line=null,this.space_before_token=!1,this.add_outputline=function(){this.previous_line=this.current_line,this.current_line=new OutputLine(this),lines.push(this.current_line)},this.add_outputline(),this.get_line_number=function(){return lines.length},this.add_new_line=function(force_newline){return(1!==this.get_line_number()||!this.just_added_newline())&&(!(!force_newline&&this.just_added_newline())&&(this.raw||this.add_outputline(),!0))},this.get_code=function(){var sweet_code=lines.join("\n").replace(/[\r\n\t ]+$/,"");return sweet_code},this.set_indent=function(level){if(lines.length>1){for(;level>=this.indent_cache.length;)this.indent_cache.push(this.indent_cache[this.indent_cache.length-1]+this.indent_string);return this.current_line.set_indent(level),!0}return this.current_line.set_indent(0),!1},this.add_raw_token=function(token){for(var x=0;x<token.newlines;x++)this.add_outputline();this.current_line.push(token.whitespace_before),this.current_line.push(token.text),this.space_before_token=!1},this.add_token=function(printable_token){this.add_space_before_token(),this.current_line.push(printable_token)},this.add_space_before_token=function(){this.space_before_token&&!this.just_added_newline()&&this.current_line.push(" "),this.space_before_token=!1},this.remove_redundant_indentation=function(frame){if(!frame.multiline_frame&&frame.mode!==MODE.ForInitializer&&frame.mode!==MODE.Conditional)for(var index=frame.start_line_index,output_length=lines.length;index<output_length;)lines[index].remove_indent(),index++},this.trim=function(eat_newlines){for(eat_newlines=void 0!==eat_newlines&&eat_newlines,this.current_line.trim(indent_string,baseIndentString);eat_newlines&&lines.length>1&&this.current_line.is_empty();)lines.pop(),this.current_line=lines[lines.length-1],this.current_line.trim();this.previous_line=lines.length>1?lines[lines.length-2]:null},this.just_added_newline=function(){return this.current_line.is_empty()},this.just_added_blankline=function(){if(this.just_added_newline()){if(1===lines.length)return!0;var line=lines[lines.length-2];
return line.is_empty()}return!1}}function tokenizer(input_string,opts){function get_directives(text){if(!text.match(directives_block_pattern))return null;var directives={};directive_pattern.lastIndex=0;for(var directive_match=directive_pattern.exec(text);directive_match;)directives[directive_match[1]]=directive_match[2],directive_match=directive_pattern.exec(text);return directives}function tokenize_next(){var resulting_string,whitespace_on_this_line=[];n_newlines=0,whitespace_before_token="";var c=input.next();if(null===c)return["","TK_EOF"];var last_token;for(last_token=tokens.length?tokens[tokens.length-1]:new Token("TK_START_BLOCK","{");in_array(c,whitespace);)if(acorn.newline.test(c)?"\n"===c&&"\r"===input.peek(-2)||(n_newlines+=1,whitespace_on_this_line=[]):whitespace_on_this_line.push(c),c=input.next(),null===c)return["","TK_EOF"];if(whitespace_on_this_line.length&&(whitespace_before_token=whitespace_on_this_line.join("")),digit.test(c)||"."===c&&input.testChar(digit)){var allow_decimal=!0,allow_e=!0,local_digit=digit;for("0"===c&&input.testChar(/[XxOoBb]/)?(allow_decimal=!1,allow_e=!1,local_digit=input.testChar(/[Bb]/)?digit_bin:input.testChar(/[Oo]/)?digit_oct:digit_hex,c+=input.next()):"."===c?allow_decimal=!1:(c="",input.back());input.testChar(local_digit);)c+=input.next(),allow_decimal&&"."===input.peek()&&(c+=input.next(),allow_decimal=!1),allow_e&&input.testChar(/[Ee]/)&&(c+=input.next(),input.testChar(/[+-]/)&&(c+=input.next()),allow_e=!1,allow_decimal=!1);return[c,"TK_WORD"]}if(acorn.isIdentifierStart(input.peekCharCode(-1))){if(input.hasNext())for(;acorn.isIdentifierChar(input.peekCharCode())&&(c+=input.next(),input.hasNext()););return"TK_DOT"===last_token.type||"TK_RESERVED"===last_token.type&&in_array(last_token.text,["set","get"])||!in_array(c,reserved_words)?[c,"TK_WORD"]:"in"===c||"of"===c?[c,"TK_OPERATOR"]:[c,"TK_RESERVED"]}if("("===c||"["===c)return[c,"TK_START_EXPR"];if(")"===c||"]"===c)return[c,"TK_END_EXPR"];if("{"===c)return[c,"TK_START_BLOCK"];if("}"===c)return[c,"TK_END_BLOCK"];if(";"===c)return[c,"TK_SEMICOLON"];if("/"===c){var comment_match,comment="";if("*"===input.peek()){input.next(),comment_match=input.match(block_comment_pattern),comment="/*"+comment_match[0];var directives=get_directives(comment);return directives&&"start"===directives.ignore&&(comment_match=input.match(directives_end_ignore_pattern),comment+=comment_match[0]),comment=comment.replace(acorn.allLineBreaks,"\n"),[comment,"TK_BLOCK_COMMENT",directives]}if("/"===input.peek())return input.next(),comment_match=input.match(comment_pattern),comment="//"+comment_match[0],[comment,"TK_COMMENT"]}var startXmlRegExp=/<()([-a-zA-Z:0-9_.]+|{[\s\S]+?}|!\[CDATA\[[\s\S]*?\]\])(\s+{[\s\S]+?}|\s+[-a-zA-Z:0-9_.]+|\s+[-a-zA-Z:0-9_.]+\s*=\s*('[^']*'|"[^"]*"|{[\s\S]+?}))*\s*(\/?)\s*>/g;if("`"===c||"'"===c||'"'===c||("/"===c||opts.e4x&&"<"===c&&input.test(startXmlRegExp,-1))&&("TK_RESERVED"===last_token.type&&in_array(last_token.text,["return","case","throw","else","do","typeof","yield"])||"TK_END_EXPR"===last_token.type&&")"===last_token.text&&last_token.parent&&"TK_RESERVED"===last_token.parent.type&&in_array(last_token.parent.text,["if","while","for"])||in_array(last_token.type,["TK_COMMENT","TK_START_EXPR","TK_START_BLOCK","TK_END_BLOCK","TK_OPERATOR","TK_EQUALS","TK_EOF","TK_SEMICOLON","TK_COMMA"]))){var sep=c,esc=!1,has_char_escapes=!1;if(resulting_string=c,"/"===sep)for(var in_char_class=!1;input.hasNext()&&(esc||in_char_class||input.peek()!==sep)&&!input.testChar(acorn.newline);)resulting_string+=input.peek(),esc?esc=!1:(esc="\\"===input.peek(),"["===input.peek()?in_char_class=!0:"]"===input.peek()&&(in_char_class=!1)),input.next();else if(opts.e4x&&"<"===sep){var xmlRegExp=/[\s\S]*?<(\/?)([-a-zA-Z:0-9_.]+|{[\s\S]+?}|!\[CDATA\[[\s\S]*?\]\])(\s+{[\s\S]+?}|\s+[-a-zA-Z:0-9_.]+|\s+[-a-zA-Z:0-9_.]+\s*=\s*('[^']*'|"[^"]*"|{[\s\S]+?}))*\s*(\/?)\s*>/g;input.back();var xmlStr="",match=input.match(startXmlRegExp);if(match){for(var rootTag=match[2].replace(/^{\s+/,"{").replace(/\s+}$/,"}"),isCurlyRoot=0===rootTag.indexOf("{"),depth=0;match;){var isEndTag=!!match[1],tagName=match[2],isSingletonTag=!!match[match.length-1]||"![CDATA["===tagName.slice(0,8);if(!isSingletonTag&&(tagName===rootTag||isCurlyRoot&&tagName.replace(/^{\s+/,"{").replace(/\s+}$/,"}"))&&(isEndTag?--depth:++depth),xmlStr+=match[0],depth<=0)break;match=input.match(xmlRegExp)}return match||(xmlStr+=input.match(/[\s\S]*/g)[0]),xmlStr=xmlStr.replace(acorn.allLineBreaks,"\n"),[xmlStr,"TK_STRING"]}}else{var parse_string=function(delimiter,allow_unescaped_newlines,start_sub){for(var current_char;input.hasNext()&&(current_char=input.peek(),esc||current_char!==delimiter&&(allow_unescaped_newlines||!acorn.newline.test(current_char)));)(esc||allow_unescaped_newlines)&&acorn.newline.test(current_char)?("\r"===current_char&&"\n"===input.peek(1)&&(input.next(),current_char=input.peek()),resulting_string+="\n"):resulting_string+=current_char,esc?("x"!==current_char&&"u"!==current_char||(has_char_escapes=!0),esc=!1):esc="\\"===current_char,input.next(),start_sub&&resulting_string.indexOf(start_sub,resulting_string.length-start_sub.length)!==-1&&("`"===delimiter?parse_string("}",allow_unescaped_newlines,"`"):parse_string("`",allow_unescaped_newlines,"${"),input.hasNext()&&(resulting_string+=input.next()))};"`"===sep?parse_string("`",!0,"${"):parse_string(sep)}if(has_char_escapes&&opts.unescape_strings&&(resulting_string=unescape_string(resulting_string)),input.peek()===sep&&(resulting_string+=sep,input.next(),"/"===sep))for(;input.hasNext()&&acorn.isIdentifierStart(input.peekCharCode());)resulting_string+=input.next();return[resulting_string,"TK_STRING"]}if("#"===c){if(0===tokens.length&&"!"===input.peek()){for(resulting_string=c;input.hasNext()&&"\n"!==c;)c=input.next(),resulting_string+=c;return[trim(resulting_string)+"\n","TK_UNKNOWN"]}var sharp="#";if(input.hasNext()&&input.testChar(digit)){do c=input.next(),sharp+=c;while(input.hasNext()&&"#"!==c&&"="!==c);return"#"===c||("["===input.peek()&&"]"===input.peek(1)?(sharp+="[]",input.next(),input.next()):"{"===input.peek()&&"}"===input.peek(1)&&(sharp+="{}",input.next(),input.next())),[sharp,"TK_WORD"]}}if("<"===c&&("?"===input.peek()||"%"===input.peek())){input.back();var template_match=input.match(template_pattern);if(template_match)return c=template_match[0],c=c.replace(acorn.allLineBreaks,"\n"),[c,"TK_STRING"]}if("<"===c&&input.match(/\!--/g)){for(c="<!--";input.hasNext()&&!input.testChar(acorn.newline);)c+=input.next();return in_html_comment=!0,[c,"TK_COMMENT"]}if("-"===c&&in_html_comment&&input.match(/->/g))return in_html_comment=!1,["-->","TK_COMMENT"];if("."===c)return"."===input.peek()&&"."===input.peek(1)?(c+=input.next()+input.next(),[c,"TK_OPERATOR"]):[c,"TK_DOT"];if(in_array(c,punct)){for(;input.hasNext()&&in_array(c+input.peek(),punct)&&(c+=input.next(),input.hasNext()););return","===c?[c,"TK_COMMA"]:"="===c?[c,"TK_EQUALS"]:[c,"TK_OPERATOR"]}return[c,"TK_UNKNOWN"]}function unescape_string(s){for(var out="",escaped=0,input_scan=new InputScanner(s),matched=null;input_scan.hasNext();)if(matched=input_scan.match(/([\s]|[^\\]|\\\\)+/g),matched&&(out+=matched[0]),"\\"===input_scan.peek()){if(input_scan.next(),"x"===input_scan.peek())matched=input_scan.match(/x([0-9A-Fa-f]{2})/g);else{if("u"!==input_scan.peek()){out+="\\",input_scan.hasNext()&&(out+=input_scan.next());continue}matched=input_scan.match(/u([0-9A-Fa-f]{4})/g)}if(!matched)return s;if(escaped=parseInt(matched[1],16),escaped>126&&escaped<=255&&0===matched[0].indexOf("x"))return s;if(escaped>=0&&escaped<32){out+="\\"+matched[0];continue}out+=34===escaped||39===escaped||92===escaped?"\\"+String.fromCharCode(escaped):String.fromCharCode(escaped)}return out}var whitespace="\n\r\t ".split(""),digit=/[0-9]/,digit_bin=/[01]/,digit_oct=/[01234567]/,digit_hex=/[0123456789abcdefABCDEF]/;this.positionable_operators="!= !== % & && * ** + - / : < << <= == === > >= >> >>> ? ^ | ||".split(" ");var punct=this.positionable_operators.concat("! %= &= *= **= ++ += , -- -= /= :: <<= = => >>= >>>= ^= |= ~ ...".split(" "));this.line_starters="continue,try,throw,return,var,let,const,if,switch,case,default,for,while,break,function,import,export".split(",");var n_newlines,whitespace_before_token,in_html_comment,tokens,input,reserved_words=this.line_starters.concat(["do","in","of","else","get","set","new","catch","finally","typeof","yield","async","await","from","as"]),block_comment_pattern=/([\s\S]*?)((?:\*\/)|$)/g,comment_pattern=/([^\n\r\u2028\u2029]*)/g,directives_block_pattern=/\/\* beautify( \w+[:]\w+)+ \*\//g,directive_pattern=/ (\w+)[:](\w+)/g,directives_end_ignore_pattern=/([\s\S]*?)((?:\/\*\sbeautify\signore:end\s\*\/)|$)/g,template_pattern=/((<\?php|<\?=)[\s\S]*?\?>)|(<%[\s\S]*?%>)/g;this.tokenize=function(){input=new InputScanner(input_string),in_html_comment=!1,tokens=[];for(var next,last,token_values,open=null,open_stack=[],comments=[];!last||"TK_EOF"!==last.type;){for(token_values=tokenize_next(),next=new Token(token_values[1],token_values[0],n_newlines,whitespace_before_token);"TK_COMMENT"===next.type||"TK_BLOCK_COMMENT"===next.type||"TK_UNKNOWN"===next.type;)"TK_BLOCK_COMMENT"===next.type&&(next.directives=token_values[2]),comments.push(next),token_values=tokenize_next(),next=new Token(token_values[1],token_values[0],n_newlines,whitespace_before_token);comments.length&&(next.comments_before=comments,comments=[]),"TK_START_BLOCK"===next.type||"TK_START_EXPR"===next.type?(next.parent=last,open_stack.push(open),open=next):("TK_END_BLOCK"===next.type||"TK_END_EXPR"===next.type)&&open&&("]"===next.text&&"["===open.text||")"===next.text&&"("===open.text||"}"===next.text&&"{"===open.text)&&(next.parent=open.parent,next.opened=open,open=open_stack.pop()),tokens.push(next),last=next}return tokens}}var acorn={};!function(exports){var nonASCIIidentifierStartChars="\xaa\xb5\xba\xc0-\xd6\xd8-\xf6\xf8-\u02c1\u02c6-\u02d1\u02e0-\u02e4\u02ec\u02ee\u0370-\u0374\u0376\u0377\u037a-\u037d\u0386\u0388-\u038a\u038c\u038e-\u03a1\u03a3-\u03f5\u03f7-\u0481\u048a-\u0527\u0531-\u0556\u0559\u0561-\u0587\u05d0-\u05ea\u05f0-\u05f2\u0620-\u064a\u066e\u066f\u0671-\u06d3\u06d5\u06e5\u06e6\u06ee\u06ef\u06fa-\u06fc\u06ff\u0710\u0712-\u072f\u074d-\u07a5\u07b1\u07ca-\u07ea\u07f4\u07f5\u07fa\u0800-\u0815\u081a\u0824\u0828\u0840-\u0858\u08a0\u08a2-\u08ac\u0904-\u0939\u093d\u0950\u0958-\u0961\u0971-\u0977\u0979-\u097f\u0985-\u098c\u098f\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09bd\u09ce\u09dc\u09dd\u09df-\u09e1\u09f0\u09f1\u0a05-\u0a0a\u0a0f\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32\u0a33\u0a35\u0a36\u0a38\u0a39\u0a59-\u0a5c\u0a5e\u0a72-\u0a74\u0a85-\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2\u0ab3\u0ab5-\u0ab9\u0abd\u0ad0\u0ae0\u0ae1\u0b05-\u0b0c\u0b0f\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32\u0b33\u0b35-\u0b39\u0b3d\u0b5c\u0b5d\u0b5f-\u0b61\u0b71\u0b83\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99\u0b9a\u0b9c\u0b9e\u0b9f\u0ba3\u0ba4\u0ba8-\u0baa\u0bae-\u0bb9\u0bd0\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c33\u0c35-\u0c39\u0c3d\u0c58\u0c59\u0c60\u0c61\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cbd\u0cde\u0ce0\u0ce1\u0cf1\u0cf2\u0d05-\u0d0c\u0d0e-\u0d10\u0d12-\u0d3a\u0d3d\u0d4e\u0d60\u0d61\u0d7a-\u0d7f\u0d85-\u0d96\u0d9a-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0e01-\u0e30\u0e32\u0e33\u0e40-\u0e46\u0e81\u0e82\u0e84\u0e87\u0e88\u0e8a\u0e8d\u0e94-\u0e97\u0e99-\u0e9f\u0ea1-\u0ea3\u0ea5\u0ea7\u0eaa\u0eab\u0ead-\u0eb0\u0eb2\u0eb3\u0ebd\u0ec0-\u0ec4\u0ec6\u0edc-\u0edf\u0f00\u0f40-\u0f47\u0f49-\u0f6c\u0f88-\u0f8c\u1000-\u102a\u103f\u1050-\u1055\u105a-\u105d\u1061\u1065\u1066\u106e-\u1070\u1075-\u1081\u108e\u10a0-\u10c5\u10c7\u10cd\u10d0-\u10fa\u10fc-\u1248\u124a-\u124d\u1250-\u1256\u1258\u125a-\u125d\u1260-\u1288\u128a-\u128d\u1290-\u12b0\u12b2-\u12b5\u12b8-\u12be\u12c0\u12c2-\u12c5\u12c8-\u12d6\u12d8-\u1310\u1312-\u1315\u1318-\u135a\u1380-\u138f\u13a0-\u13f4\u1401-\u166c\u166f-\u167f\u1681-\u169a\u16a0-\u16ea\u16ee-\u16f0\u1700-\u170c\u170e-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176c\u176e-\u1770\u1780-\u17b3\u17d7\u17dc\u1820-\u1877\u1880-\u18a8\u18aa\u18b0-\u18f5\u1900-\u191c\u1950-\u196d\u1970-\u1974\u1980-\u19ab\u19c1-\u19c7\u1a00-\u1a16\u1a20-\u1a54\u1aa7\u1b05-\u1b33\u1b45-\u1b4b\u1b83-\u1ba0\u1bae\u1baf\u1bba-\u1be5\u1c00-\u1c23\u1c4d-\u1c4f\u1c5a-\u1c7d\u1ce9-\u1cec\u1cee-\u1cf1\u1cf5\u1cf6\u1d00-\u1dbf\u1e00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc2-\u1fc4\u1fc6-\u1fcc\u1fd0-\u1fd3\u1fd6-\u1fdb\u1fe0-\u1fec\u1ff2-\u1ff4\u1ff6-\u1ffc\u2071\u207f\u2090-\u209c\u2102\u2107\u210a-\u2113\u2115\u2119-\u211d\u2124\u2126\u2128\u212a-\u212d\u212f-\u2139\u213c-\u213f\u2145-\u2149\u214e\u2160-\u2188\u2c00-\u2c2e\u2c30-\u2c5e\u2c60-\u2ce4\u2ceb-\u2cee\u2cf2\u2cf3\u2d00-\u2d25\u2d27\u2d2d\u2d30-\u2d67\u2d6f\u2d80-\u2d96\u2da0-\u2da6\u2da8-\u2dae\u2db0-\u2db6\u2db8-\u2dbe\u2dc0-\u2dc6\u2dc8-\u2dce\u2dd0-\u2dd6\u2dd8-\u2dde\u2e2f\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303c\u3041-\u3096\u309d-\u309f\u30a1-\u30fa\u30fc-\u30ff\u3105-\u312d\u3131-\u318e\u31a0-\u31ba\u31f0-\u31ff\u3400-\u4db5\u4e00-\u9fcc\ua000-\ua48c\ua4d0-\ua4fd\ua500-\ua60c\ua610-\ua61f\ua62a\ua62b\ua640-\ua66e\ua67f-\ua697\ua6a0-\ua6ef\ua717-\ua71f\ua722-\ua788\ua78b-\ua78e\ua790-\ua793\ua7a0-\ua7aa\ua7f8-\ua801\ua803-\ua805\ua807-\ua80a\ua80c-\ua822\ua840-\ua873\ua882-\ua8b3\ua8f2-\ua8f7\ua8fb\ua90a-\ua925\ua930-\ua946\ua960-\ua97c\ua984-\ua9b2\ua9cf\uaa00-\uaa28\uaa40-\uaa42\uaa44-\uaa4b\uaa60-\uaa76\uaa7a\uaa80-\uaaaf\uaab1\uaab5\uaab6\uaab9-\uaabd\uaac0\uaac2\uaadb-\uaadd\uaae0-\uaaea\uaaf2-\uaaf4\uab01-\uab06\uab09-\uab0e\uab11-\uab16\uab20-\uab26\uab28-\uab2e\uabc0-\uabe2\uac00-\ud7a3\ud7b0-\ud7c6\ud7cb-\ud7fb\uf900-\ufa6d\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\ufb1d\ufb1f-\ufb28\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40\ufb41\ufb43\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfb\ufe70-\ufe74\ufe76-\ufefc\uff21-\uff3a\uff41-\uff5a\uff66-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc",nonASCIIidentifierChars="\u0300-\u036f\u0483-\u0487\u0591-\u05bd\u05bf\u05c1\u05c2\u05c4\u05c5\u05c7\u0610-\u061a\u0620-\u0649\u0672-\u06d3\u06e7-\u06e8\u06fb-\u06fc\u0730-\u074a\u0800-\u0814\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0840-\u0857\u08e4-\u08fe\u0900-\u0903\u093a-\u093c\u093e-\u094f\u0951-\u0957\u0962-\u0963\u0966-\u096f\u0981-\u0983\u09bc\u09be-\u09c4\u09c7\u09c8\u09d7\u09df-\u09e0\u0a01-\u0a03\u0a3c\u0a3e-\u0a42\u0a47\u0a48\u0a4b-\u0a4d\u0a51\u0a66-\u0a71\u0a75\u0a81-\u0a83\u0abc\u0abe-\u0ac5\u0ac7-\u0ac9\u0acb-\u0acd\u0ae2-\u0ae3\u0ae6-\u0aef\u0b01-\u0b03\u0b3c\u0b3e-\u0b44\u0b47\u0b48\u0b4b-\u0b4d\u0b56\u0b57\u0b5f-\u0b60\u0b66-\u0b6f\u0b82\u0bbe-\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcd\u0bd7\u0be6-\u0bef\u0c01-\u0c03\u0c46-\u0c48\u0c4a-\u0c4d\u0c55\u0c56\u0c62-\u0c63\u0c66-\u0c6f\u0c82\u0c83\u0cbc\u0cbe-\u0cc4\u0cc6-\u0cc8\u0cca-\u0ccd\u0cd5\u0cd6\u0ce2-\u0ce3\u0ce6-\u0cef\u0d02\u0d03\u0d46-\u0d48\u0d57\u0d62-\u0d63\u0d66-\u0d6f\u0d82\u0d83\u0dca\u0dcf-\u0dd4\u0dd6\u0dd8-\u0ddf\u0df2\u0df3\u0e34-\u0e3a\u0e40-\u0e45\u0e50-\u0e59\u0eb4-\u0eb9\u0ec8-\u0ecd\u0ed0-\u0ed9\u0f18\u0f19\u0f20-\u0f29\u0f35\u0f37\u0f39\u0f41-\u0f47\u0f71-\u0f84\u0f86-\u0f87\u0f8d-\u0f97\u0f99-\u0fbc\u0fc6\u1000-\u1029\u1040-\u1049\u1067-\u106d\u1071-\u1074\u1082-\u108d\u108f-\u109d\u135d-\u135f\u170e-\u1710\u1720-\u1730\u1740-\u1750\u1772\u1773\u1780-\u17b2\u17dd\u17e0-\u17e9\u180b-\u180d\u1810-\u1819\u1920-\u192b\u1930-\u193b\u1951-\u196d\u19b0-\u19c0\u19c8-\u19c9\u19d0-\u19d9\u1a00-\u1a15\u1a20-\u1a53\u1a60-\u1a7c\u1a7f-\u1a89\u1a90-\u1a99\u1b46-\u1b4b\u1b50-\u1b59\u1b6b-\u1b73\u1bb0-\u1bb9\u1be6-\u1bf3\u1c00-\u1c22\u1c40-\u1c49\u1c5b-\u1c7d\u1cd0-\u1cd2\u1d00-\u1dbe\u1e01-\u1f15\u200c\u200d\u203f\u2040\u2054\u20d0-\u20dc\u20e1\u20e5-\u20f0\u2d81-\u2d96\u2de0-\u2dff\u3021-\u3028\u3099\u309a\ua640-\ua66d\ua674-\ua67d\ua69f\ua6f0-\ua6f1\ua7f8-\ua800\ua806\ua80b\ua823-\ua827\ua880-\ua881\ua8b4-\ua8c4\ua8d0-\ua8d9\ua8f3-\ua8f7\ua900-\ua909\ua926-\ua92d\ua930-\ua945\ua980-\ua983\ua9b3-\ua9c0\uaa00-\uaa27\uaa40-\uaa41\uaa4c-\uaa4d\uaa50-\uaa59\uaa7b\uaae0-\uaae9\uaaf2-\uaaf3\uabc0-\uabe1\uabec\uabed\uabf0-\uabf9\ufb20-\ufb28\ufe00-\ufe0f\ufe20-\ufe26\ufe33\ufe34\ufe4d-\ufe4f\uff10-\uff19\uff3f",nonASCIIidentifierStart=new RegExp("["+nonASCIIidentifierStartChars+"]"),nonASCIIidentifier=new RegExp("["+nonASCIIidentifierStartChars+nonASCIIidentifierChars+"]");exports.newline=/[\n\r\u2028\u2029]/,exports.lineBreak=new RegExp("\r\n|"+exports.newline.source),exports.allLineBreaks=new RegExp(exports.lineBreak.source,"g"),exports.isIdentifierStart=function(code){return code<65?36===code||64===code:code<91||(code<97?95===code:code<123||code>=170&&nonASCIIidentifierStart.test(String.fromCharCode(code)))},exports.isIdentifierChar=function(code){return code<48?36===code:code<58||!(code<65)&&(code<91||(code<97?95===code:code<123||code>=170&&nonASCIIidentifier.test(String.fromCharCode(code))))}}(acorn);var OPERATOR_POSITION={before_newline:"before-newline",after_newline:"after-newline",preserve_newline:"preserve-newline"},OPERATOR_POSITION_BEFORE_OR_PRESERVE=[OPERATOR_POSITION.before_newline,OPERATOR_POSITION.preserve_newline],MODE={BlockStatement:"BlockStatement",Statement:"Statement",ObjectLiteral:"ObjectLiteral",ArrayLiteral:"ArrayLiteral",ForInitializer:"ForInitializer",Conditional:"Conditional",Expression:"Expression"},InputScanner=function(input){var _input=input,_input_length=_input.length,_position=0;this.back=function(){_position-=1},this.hasNext=function(){return _position<_input_length},this.next=function(){var val=null;return this.hasNext()&&(val=_input.charAt(_position),_position+=1),val},this.peek=function(index){var val=null;return index=index||0,index+=_position,index>=0&&index<_input_length&&(val=_input.charAt(index)),val},this.peekCharCode=function(index){var val=0;return index=index||0,index+=_position,index>=0&&index<_input_length&&(val=_input.charCodeAt(index)),val},this.test=function(pattern,index){return index=index||0,pattern.lastIndex=_position+index,pattern.test(_input)},this.testChar=function(pattern,index){var val=this.peek(index);return null!==val&&pattern.test(val)},this.match=function(pattern){pattern.lastIndex=_position;var pattern_match=pattern.exec(_input);return pattern_match&&pattern_match.index===_position?_position+=pattern_match[0].length:pattern_match=null,pattern_match}},Token=function(type,text,newlines,whitespace_before,parent){this.type=type,this.text=text,this.comments_before=[],this.comments_after=[],this.newlines=newlines||0,this.wanted_newline=newlines>0,this.whitespace_before=whitespace_before||"",this.parent=parent||null,this.opened=null,this.directives=null},beautifier=new Beautifier(js_source_text,options);return beautifier.beautify()}"function"==typeof define&&define.amd?define([],function(){return{js_beautify:js_beautify}}):"undefined"!=typeof exports?exports.js_beautify=js_beautify:"undefined"!=typeof window?window.js_beautify=js_beautify:"undefined"!=typeof global&&(global.js_beautify=js_beautify)}(),function(){function mergeOpts(allOptions,targetType){var name,finalOpts={};for(name in allOptions)name!==targetType&&(finalOpts[name]=allOptions[name]);if(targetType in allOptions)for(name in allOptions[targetType])finalOpts[name]=allOptions[targetType][name];return finalOpts}function css_beautify(source_text,options){function next(){return ch=source_text.charAt(++pos),ch||""}function peek(skipWhitespace){var result="",prev_pos=pos;return skipWhitespace&&eatWhitespace(),result=source_text.charAt(pos+1)||"",pos=prev_pos-1,next(),result}function eatString(endChars){for(var start=pos;next();)if("\\"===ch)next();else{if(endChars.indexOf(ch)!==-1)break;if("\n"===ch)break}return source_text.substring(start,pos+1)}function peekString(endChar){var prev_pos=pos,str=eatString(endChar);return pos=prev_pos-1,next(),str}function eatWhitespace(){for(var result="";whiteRe.test(peek());)next(),result+=ch;return result}function skipWhitespace(){var result="";for(ch&&whiteRe.test(ch)&&(result=ch);whiteRe.test(next());)result+=ch;return result}function eatComment(singleLine){var start=pos;for(singleLine="/"===peek(),next();next();){if(!singleLine&&"*"===ch&&"/"===peek()){next();break}if(singleLine&&"\n"===ch)return source_text.substring(start,pos)}return source_text.substring(start,pos)+ch}function lookBack(str){return source_text.substring(pos-str.length,pos).toLowerCase()===str}function foundNestedPseudoClass(){for(var openParen=0,i=pos+1;i<source_text.length;i++){var ch=source_text.charAt(i);if("{"===ch)return!0;if("("===ch)openParen+=1;else if(")"===ch){if(0===openParen)return!1;openParen-=1}else if(";"===ch||"}"===ch)return!1}return!1}function indent(){indentLevel++,basebaseIndentString+=singleIndent}function outdent(){indentLevel--,basebaseIndentString=basebaseIndentString.slice(0,-indentSize)}options=options||{},options=mergeOpts(options,"css"),source_text=source_text||"";var indentSize=options.indent_size?parseInt(options.indent_size,10):4,indentCharacter=options.indent_char||" ",selectorSeparatorNewline=void 0===options.selector_separator_newline||options.selector_separator_newline,end_with_newline=void 0!==options.end_with_newline&&options.end_with_newline,newline_between_rules=void 0===options.newline_between_rules||options.newline_between_rules,space_around_combinator=void 0!==options.space_around_combinator&&options.space_around_combinator;space_around_combinator=space_around_combinator||void 0!==options.space_around_selector_separator&&options.space_around_selector_separator;var eol=options.eol?options.eol:"auto";options.indent_with_tabs&&(indentCharacter="\t",indentSize=1),"auto"===eol&&(eol="\n",source_text&&lineBreak.test(source_text||"")&&(eol=source_text.match(lineBreak)[0])),eol=eol.replace(/\\r/,"\r").replace(/\\n/,"\n"),source_text=source_text.replace(allLineBreaks,"\n");var ch,whiteRe=/^\s+$/,pos=-1,parenLevel=0,basebaseIndentString=source_text.match(/^[\t ]*/)[0],singleIndent=new Array(indentSize+1).join(indentCharacter),indentLevel=0,nestedLevel=0,print={};print["{"]=function(ch){print.singleSpace(),output.push(ch),print.newLine()},print["}"]=function(ch){print.newLine(),output.push(ch),print.newLine()},print._lastCharWhitespace=function(){return whiteRe.test(output[output.length-1])},print.newLine=function(keepWhitespace){output.length&&(keepWhitespace||"\n"===output[output.length-1]||print.trim(),output.push("\n"),basebaseIndentString&&output.push(basebaseIndentString))},print.singleSpace=function(){output.length&&!print._lastCharWhitespace()&&output.push(" ")},print.preserveSingleSpace=function(){isAfterSpace&&print.singleSpace()},print.trim=function(){for(;print._lastCharWhitespace();)output.pop()};for(var output=[],insideRule=!1,insidePropertyValue=!1,enteringConditionalGroup=!1,top_ch="",last_top_ch="";;){var whitespace=skipWhitespace(),isAfterSpace=""!==whitespace,isAfterNewline=whitespace.indexOf("\n")!==-1;if(last_top_ch=top_ch,top_ch=ch,!ch)break;if("/"===ch&&"*"===peek()){var header=0===indentLevel;(isAfterNewline||header)&&print.newLine(),output.push(eatComment()),print.newLine(),header&&print.newLine(!0)}else if("/"===ch&&"/"===peek())isAfterNewline||"{"===last_top_ch||print.trim(),print.singleSpace(),output.push(eatComment()),print.newLine();else if("@"===ch)if(print.preserveSingleSpace(),"{"===peek())output.push(eatString("}"));else{output.push(ch);var variableOrRule=peekString(": ,;{}()[]/='\"");variableOrRule.match(/[ :]$/)&&(next(),variableOrRule=eatString(": ").replace(/\s$/,""),output.push(variableOrRule),print.singleSpace()),variableOrRule=variableOrRule.replace(/\s$/,""),variableOrRule in css_beautify.NESTED_AT_RULE&&(nestedLevel+=1,variableOrRule in css_beautify.CONDITIONAL_GROUP_RULE&&(enteringConditionalGroup=!0))}else"#"===ch&&"{"===peek()?(print.preserveSingleSpace(),output.push(eatString("}"))):"{"===ch?"}"===peek(!0)?(eatWhitespace(),next(),print.singleSpace(),output.push("{}"),print.newLine(),newline_between_rules&&0===indentLevel&&print.newLine(!0)):(indent(),print["{"](ch),enteringConditionalGroup?(enteringConditionalGroup=!1,insideRule=indentLevel>nestedLevel):insideRule=indentLevel>=nestedLevel):"}"===ch?(outdent(),print["}"](ch),insideRule=!1,insidePropertyValue=!1,nestedLevel&&nestedLevel--,newline_between_rules&&0===indentLevel&&print.newLine(!0)):":"===ch?(eatWhitespace(),!insideRule&&!enteringConditionalGroup||lookBack("&")||foundNestedPseudoClass()||lookBack("(")?(lookBack(" ")&&" "!==output[output.length-1]&&output.push(" "),":"===peek()?(next(),output.push("::")):output.push(":")):(output.push(":"),insidePropertyValue||(insidePropertyValue=!0,print.singleSpace()))):'"'===ch||"'"===ch?(print.preserveSingleSpace(),output.push(eatString(ch))):";"===ch?(insidePropertyValue=!1,output.push(ch),print.newLine()):"("===ch?lookBack("url")?(output.push(ch),eatWhitespace(),next()&&(")"!==ch&&'"'!==ch&&"'"!==ch?output.push(eatString(")")):pos--)):(parenLevel++,print.preserveSingleSpace(),output.push(ch),eatWhitespace()):")"===ch?(output.push(ch),parenLevel--):","===ch?(output.push(ch),eatWhitespace(),selectorSeparatorNewline&&!insidePropertyValue&&parenLevel<1?print.newLine():print.singleSpace()):(">"===ch||"+"===ch||"~"===ch)&&!insidePropertyValue&&parenLevel<1?space_around_combinator?(print.singleSpace(),output.push(ch),print.singleSpace()):(output.push(ch),eatWhitespace(),ch&&whiteRe.test(ch)&&(ch="")):"]"===ch?output.push(ch):"["===ch?(print.preserveSingleSpace(),output.push(ch)):"="===ch?(eatWhitespace(),ch="=",output.push(ch)):(print.preserveSingleSpace(),output.push(ch))}var sweetCode="";return basebaseIndentString&&(sweetCode+=basebaseIndentString),sweetCode+=output.join("").replace(/[\r\n\t ]+$/,""),end_with_newline&&(sweetCode+="\n"),"\n"!==eol&&(sweetCode=sweetCode.replace(/[\n]/g,eol)),sweetCode}var lineBreak=/\r\n|[\n\r\u2028\u2029]/,allLineBreaks=new RegExp(lineBreak.source,"g");css_beautify.NESTED_AT_RULE={"@page":!0,"@font-face":!0,"@keyframes":!0,"@media":!0,"@supports":!0,"@document":!0},css_beautify.CONDITIONAL_GROUP_RULE={"@media":!0,"@supports":!0,"@document":!0},"function"==typeof define&&define.amd?define([],function(){return{css_beautify:css_beautify}}):"undefined"!=typeof exports?exports.css_beautify=css_beautify:"undefined"!=typeof window?window.css_beautify=css_beautify:"undefined"!=typeof global&&(global.css_beautify=css_beautify)}(),function(){function ltrim(s){return s.replace(/^\s+/g,"")}function rtrim(s){return s.replace(/\s+$/g,"")}function mergeOpts(allOptions,targetType){var name,finalOpts={};for(name in allOptions)name!==targetType&&(finalOpts[name]=allOptions[name]);if(targetType in allOptions)for(name in allOptions[targetType])finalOpts[name]=allOptions[targetType][name];return finalOpts}function style_html(html_source,options,js_beautify,css_beautify){function Parser(){function tokenMatcher(delimiter){var token="",add=function(str){var newToken=token+str.toLowerCase();token=newToken.length<=delimiter.length?newToken:newToken.substr(newToken.length-delimiter.length,delimiter.length)},doesNotMatch=function(){return token.indexOf(delimiter)===-1};return{add:add,doesNotMatch:doesNotMatch}}return this.pos=0,this.token="",this.current_mode="CONTENT",this.tags={parent:"parent1",parentcount:1,parent1:""},this.tag_type="",this.token_text=this.last_token=this.last_text=this.token_type="",this.newlines=0,this.indent_content=indent_inner_html,this.indent_body_inner_html=indent_body_inner_html,this.indent_head_inner_html=indent_head_inner_html,this.Utils={whitespace:"\n\r\t ".split(""),single_token:["area","base","br","col","embed","hr","img","input","keygen","link","menuitem","meta","param","source","track","wbr","!doctype","?xml","?php","basefont","isindex"],extra_liners:extra_liners,in_array:function(what,arr){for(var i=0;i<arr.length;i++)if(what===arr[i])return!0;return!1}},this.is_whitespace=function(text){for(var n=0;n<text.length;n++)if(!this.Utils.in_array(text.charAt(n),this.Utils.whitespace))return!1;return!0},this.traverse_whitespace=function(){var input_char="";if(input_char=this.input.charAt(this.pos),this.Utils.in_array(input_char,this.Utils.whitespace)){for(this.newlines=0;this.Utils.in_array(input_char,this.Utils.whitespace);)preserve_newlines&&"\n"===input_char&&this.newlines<=max_preserve_newlines&&(this.newlines+=1),this.pos++,input_char=this.input.charAt(this.pos);return!0}return!1},this.space_or_wrap=function(content){return this.line_char_count>=this.wrap_line_length?(this.print_newline(!1,content),this.print_indentation(content),!0):(this.line_char_count++,content.push(" "),!1)},this.get_content=function(){for(var input_char="",content=[],handlebarsStarted=0;"<"!==this.input.charAt(this.pos)||2===handlebarsStarted;){if(this.pos>=this.input.length)return content.length?content.join(""):["","TK_EOF"];if(this.traverse_whitespace())this.space_or_wrap(content);else{if(input_char=this.input.charAt(this.pos),indent_handlebars){if("{"===input_char?handlebarsStarted+=1:handlebarsStarted<2&&(handlebarsStarted=0),"}"===input_char&&handlebarsStarted>0&&0===handlebarsStarted--)break;var peek3=this.input.substr(this.pos,3);if("{{#"===peek3||"{{/"===peek3)break;if("{{!"===peek3)return[this.get_tag(),"TK_TAG_HANDLEBARS_COMMENT"];if("{{"===this.input.substr(this.pos,2)&&"{{else}}"===this.get_tag(!0))break}this.pos++,this.line_char_count++,content.push(input_char)}}return content.length?content.join(""):""},this.get_contents_to=function(name){if(this.pos===this.input.length)return["","TK_EOF"];var content="",reg_match=new RegExp("</"+name+"\\s*>","igm");reg_match.lastIndex=this.pos;var reg_array=reg_match.exec(this.input),end_script=reg_array?reg_array.index:this.input.length;return this.pos<end_script&&(content=this.input.substring(this.pos,end_script),this.pos=end_script),content},this.record_tag=function(tag){this.tags[tag+"count"]?(this.tags[tag+"count"]++,this.tags[tag+this.tags[tag+"count"]]=this.indent_level):(this.tags[tag+"count"]=1,this.tags[tag+this.tags[tag+"count"]]=this.indent_level),this.tags[tag+this.tags[tag+"count"]+"parent"]=this.tags.parent,this.tags.parent=tag+this.tags[tag+"count"]},this.retrieve_tag=function(tag){if(this.tags[tag+"count"]){for(var temp_parent=this.tags.parent;temp_parent&&tag+this.tags[tag+"count"]!==temp_parent;)temp_parent=this.tags[temp_parent+"parent"];temp_parent&&(this.indent_level=this.tags[tag+this.tags[tag+"count"]],this.tags.parent=this.tags[temp_parent+"parent"]),delete this.tags[tag+this.tags[tag+"count"]+"parent"],delete this.tags[tag+this.tags[tag+"count"]],1===this.tags[tag+"count"]?delete this.tags[tag+"count"]:this.tags[tag+"count"]--}},this.indent_to_tag=function(tag){if(this.tags[tag+"count"]){for(var temp_parent=this.tags.parent;temp_parent&&tag+this.tags[tag+"count"]!==temp_parent;)temp_parent=this.tags[temp_parent+"parent"];temp_parent&&(this.indent_level=this.tags[tag+this.tags[tag+"count"]])}},this.get_tag=function(peek){var tag_start,tag_end,tag_start_char,tail,input_char="",content=[],comment="",space=!1,first_attr=!0,has_wrapped_attrs=!1,orig_pos=this.pos,orig_line_char_count=this.line_char_count,is_tag_closed=!1;peek=void 0!==peek&&peek;do{if(this.pos>=this.input.length)return peek&&(this.pos=orig_pos,this.line_char_count=orig_line_char_count),content.length?content.join(""):["","TK_EOF"];if(input_char=this.input.charAt(this.pos),this.pos++,this.Utils.in_array(input_char,this.Utils.whitespace))space=!0;else{if("'"!==input_char&&'"'!==input_char||(input_char+=this.get_unformatted(input_char),space=!0),"="===input_char&&(space=!1),tail=this.input.substr(this.pos-1),!is_wrap_attributes_force_expand_multiline||!has_wrapped_attrs||is_tag_closed||">"!==input_char&&"/"!==input_char||tail.match(/^\/?\s*>/)&&(space=!1,is_tag_closed=!0,this.print_newline(!1,content),this.print_indentation(content)),content.length&&"="!==content[content.length-1]&&">"!==input_char&&space){var wrapped=this.space_or_wrap(content),indentAttrs=wrapped&&"/"!==input_char&&!is_wrap_attributes_force;
if(space=!1,is_wrap_attributes_force&&"/"!==input_char){var force_first_attr_wrap=!1;if(is_wrap_attributes_force_expand_multiline&&first_attr){var is_only_attribute=null!==tail.match(/^\S*(="([^"]|\\")*")?\s*\/?\s*>/);force_first_attr_wrap=!is_only_attribute}first_attr&&!force_first_attr_wrap||(this.print_newline(!1,content),this.print_indentation(content),indentAttrs=!0)}if(indentAttrs){has_wrapped_attrs=!0;var alignment_size=wrap_attributes_indent_size;is_wrap_attributes_force_aligned&&(alignment_size=content.indexOf(" ")+1);for(var count=0;count<alignment_size;count++)content.push(indent_character)}if(first_attr)for(var i=0;i<content.length;i++)if(" "===content[i]){first_attr=!1;break}}if(indent_handlebars&&"<"===tag_start_char&&input_char+this.input.charAt(this.pos)==="{{"&&(input_char+=this.get_unformatted("}}"),content.length&&" "!==content[content.length-1]&&"<"!==content[content.length-1]&&(input_char=" "+input_char),space=!0),"<"!==input_char||tag_start_char||(tag_start=this.pos-1,tag_start_char="<"),indent_handlebars&&!tag_start_char&&content.length>=2&&"{"===content[content.length-1]&&"{"===content[content.length-2]&&(tag_start="#"===input_char||"/"===input_char||"!"===input_char?this.pos-3:this.pos-2,tag_start_char="{"),this.line_char_count++,content.push(input_char),content[1]&&("!"===content[1]||"?"===content[1]||"%"===content[1])){content=[this.get_comment(tag_start)];break}if(indent_handlebars&&content[1]&&"{"===content[1]&&content[2]&&"!"===content[2]){content=[this.get_comment(tag_start)];break}if(indent_handlebars&&"{"===tag_start_char&&content.length>2&&"}"===content[content.length-2]&&"}"===content[content.length-1])break}}while(">"!==input_char);var tag_index,tag_offset,tag_complete=content.join("");tag_index=tag_complete.indexOf("\n")!==-1?tag_complete.indexOf("\n"):tag_complete.indexOf(" ")!==-1?tag_complete.indexOf(" "):"{"===tag_complete.charAt(0)?tag_complete.indexOf("}"):tag_complete.indexOf(">"),tag_offset="<"!==tag_complete.charAt(0)&&indent_handlebars?"#"===tag_complete.charAt(2)?3:2:1;var tag_check=tag_complete.substring(tag_offset,tag_index).toLowerCase();return"/"===tag_complete.charAt(tag_complete.length-2)||this.Utils.in_array(tag_check,this.Utils.single_token)?peek||(this.tag_type="SINGLE"):indent_handlebars&&"{"===tag_complete.charAt(0)&&"else"===tag_check?peek||(this.indent_to_tag("if"),this.tag_type="HANDLEBARS_ELSE",this.indent_content=!0,this.traverse_whitespace()):this.is_unformatted(tag_check,unformatted)||this.is_unformatted(tag_check,content_unformatted)?(comment=this.get_unformatted("</"+tag_check+">",tag_complete),content.push(comment),tag_end=this.pos-1,this.tag_type="SINGLE"):"script"===tag_check&&(tag_complete.search("type")===-1||tag_complete.search("type")>-1&&tag_complete.search(/\b(text|application|dojo)\/(x-)?(javascript|ecmascript|jscript|livescript|(ld\+)?json|method|aspect)/)>-1)?peek||(this.record_tag(tag_check),this.tag_type="SCRIPT"):"style"===tag_check&&(tag_complete.search("type")===-1||tag_complete.search("type")>-1&&tag_complete.search("text/css")>-1)?peek||(this.record_tag(tag_check),this.tag_type="STYLE"):"!"===tag_check.charAt(0)?peek||(this.tag_type="SINGLE",this.traverse_whitespace()):peek||("/"===tag_check.charAt(0)?(this.retrieve_tag(tag_check.substring(1)),this.tag_type="END"):(this.record_tag(tag_check),"html"!==tag_check.toLowerCase()&&(this.indent_content=!0),this.tag_type="START"),this.traverse_whitespace()&&this.space_or_wrap(content),this.Utils.in_array(tag_check,this.Utils.extra_liners)&&(this.print_newline(!1,this.output),this.output.length&&"\n"!==this.output[this.output.length-2]&&this.print_newline(!0,this.output))),peek&&(this.pos=orig_pos,this.line_char_count=orig_line_char_count),content.join("")},this.get_comment=function(start_pos){var comment="",delimiter=">",matched=!1;this.pos=start_pos;var input_char=this.input.charAt(this.pos);for(this.pos++;this.pos<=this.input.length&&(comment+=input_char,comment.charAt(comment.length-1)!==delimiter.charAt(delimiter.length-1)||comment.indexOf(delimiter)===-1);)!matched&&comment.length<10&&(0===comment.indexOf("<![if")?(delimiter="<![endif]>",matched=!0):0===comment.indexOf("<![cdata[")?(delimiter="]]>",matched=!0):0===comment.indexOf("<![")?(delimiter="]>",matched=!0):0===comment.indexOf("<!--")?(delimiter="-->",matched=!0):0===comment.indexOf("{{!--")?(delimiter="--}}",matched=!0):0===comment.indexOf("{{!")?5===comment.length&&comment.indexOf("{{!--")===-1&&(delimiter="}}",matched=!0):0===comment.indexOf("<?")?(delimiter="?>",matched=!0):0===comment.indexOf("<%")&&(delimiter="%>",matched=!0)),input_char=this.input.charAt(this.pos),this.pos++;return comment},this.get_unformatted=function(delimiter,orig_tag){if(orig_tag&&orig_tag.toLowerCase().indexOf(delimiter)!==-1)return"";var input_char="",content="",space=!0,delimiterMatcher=tokenMatcher(delimiter);do{if(this.pos>=this.input.length)return content;if(input_char=this.input.charAt(this.pos),this.pos++,this.Utils.in_array(input_char,this.Utils.whitespace)){if(!space){this.line_char_count--;continue}if("\n"===input_char||"\r"===input_char){content+="\n",this.line_char_count=0;continue}}content+=input_char,delimiterMatcher.add(input_char),this.line_char_count++,space=!0,indent_handlebars&&"{"===input_char&&content.length&&"{"===content.charAt(content.length-2)&&(content+=this.get_unformatted("}}"))}while(delimiterMatcher.doesNotMatch());return content},this.get_token=function(){var token;if("TK_TAG_SCRIPT"===this.last_token||"TK_TAG_STYLE"===this.last_token){var type=this.last_token.substr(7);return token=this.get_contents_to(type),"string"!=typeof token?token:[token,"TK_"+type]}if("CONTENT"===this.current_mode)return token=this.get_content(),"string"!=typeof token?token:[token,"TK_CONTENT"];if("TAG"===this.current_mode){if(token=this.get_tag(),"string"!=typeof token)return token;var tag_name_type="TK_TAG_"+this.tag_type;return[token,tag_name_type]}},this.get_full_indent=function(level){return level=this.indent_level+level||0,level<1?"":Array(level+1).join(this.indent_string)},this.is_unformatted=function(tag_check,unformatted){if(!this.Utils.in_array(tag_check,unformatted))return!1;if("a"!==tag_check.toLowerCase()||!this.Utils.in_array("a",unformatted))return!0;var next_tag=this.get_tag(!0),tag=(next_tag||"").match(/^\s*<\s*\/?([a-z]*)\s*[^>]*>\s*$/);return!(tag&&!this.Utils.in_array(tag,unformatted))},this.printer=function(js_source,indent_character,indent_size,wrap_line_length,brace_style){this.input=js_source||"",this.input=this.input.replace(/\r\n|[\r\u2028\u2029]/g,"\n"),this.output=[],this.indent_character=indent_character,this.indent_string="",this.indent_size=indent_size,this.brace_style=brace_style,this.indent_level=0,this.wrap_line_length=wrap_line_length,this.line_char_count=0;for(var i=0;i<this.indent_size;i++)this.indent_string+=this.indent_character;this.print_newline=function(force,arr){this.line_char_count=0,arr&&arr.length&&(force||"\n"!==arr[arr.length-1])&&("\n"!==arr[arr.length-1]&&(arr[arr.length-1]=rtrim(arr[arr.length-1])),arr.push("\n"))},this.print_indentation=function(arr){for(var i=0;i<this.indent_level;i++)arr.push(this.indent_string),this.line_char_count+=this.indent_string.length},this.print_token=function(text){this.is_whitespace(text)&&!this.output.length||((text||""!==text)&&this.output.length&&"\n"===this.output[this.output.length-1]&&(this.print_indentation(this.output),text=ltrim(text)),this.print_token_raw(text))},this.print_token_raw=function(text){this.newlines>0&&(text=rtrim(text)),text&&""!==text&&(text.length>1&&"\n"===text.charAt(text.length-1)?(this.output.push(text.slice(0,-1)),this.print_newline(!1,this.output)):this.output.push(text));for(var n=0;n<this.newlines;n++)this.print_newline(n>0,this.output);this.newlines=0},this.indent=function(){this.indent_level++},this.unindent=function(){this.indent_level>0&&this.indent_level--}},this}var multi_parser,indent_inner_html,indent_body_inner_html,indent_head_inner_html,indent_size,indent_character,wrap_line_length,brace_style,unformatted,content_unformatted,preserve_newlines,max_preserve_newlines,indent_handlebars,wrap_attributes,wrap_attributes_indent_size,is_wrap_attributes_force,is_wrap_attributes_force_expand_multiline,is_wrap_attributes_force_aligned,end_with_newline,extra_liners,eol;for(options=options||{},options=mergeOpts(options,"html"),void 0!==options.wrap_line_length&&0!==parseInt(options.wrap_line_length,10)||void 0===options.max_char||0===parseInt(options.max_char,10)||(options.wrap_line_length=options.max_char),indent_inner_html=void 0!==options.indent_inner_html&&options.indent_inner_html,indent_body_inner_html=void 0===options.indent_body_inner_html||options.indent_body_inner_html,indent_head_inner_html=void 0===options.indent_head_inner_html||options.indent_head_inner_html,indent_size=void 0===options.indent_size?4:parseInt(options.indent_size,10),indent_character=void 0===options.indent_char?" ":options.indent_char,brace_style=void 0===options.brace_style?"collapse":options.brace_style,wrap_line_length=0===parseInt(options.wrap_line_length,10)?32786:parseInt(options.wrap_line_length||250,10),unformatted=options.unformatted||["a","abbr","area","audio","b","bdi","bdo","br","button","canvas","cite","code","data","datalist","del","dfn","em","embed","i","iframe","img","input","ins","kbd","keygen","label","map","mark","math","meter","noscript","object","output","progress","q","ruby","s","samp","select","small","span","strong","sub","sup","svg","template","textarea","time","u","var","video","wbr","text","acronym","address","big","dt","ins","strike","tt"],content_unformatted=options.content_unformatted||["pre"],preserve_newlines=void 0===options.preserve_newlines||options.preserve_newlines,max_preserve_newlines=preserve_newlines?isNaN(parseInt(options.max_preserve_newlines,10))?32786:parseInt(options.max_preserve_newlines,10):0,indent_handlebars=void 0!==options.indent_handlebars&&options.indent_handlebars,wrap_attributes=void 0===options.wrap_attributes?"auto":options.wrap_attributes,wrap_attributes_indent_size=isNaN(parseInt(options.wrap_attributes_indent_size,10))?indent_size:parseInt(options.wrap_attributes_indent_size,10),is_wrap_attributes_force="force"===wrap_attributes.substr(0,"force".length),is_wrap_attributes_force_expand_multiline="force-expand-multiline"===wrap_attributes,is_wrap_attributes_force_aligned="force-aligned"===wrap_attributes,end_with_newline=void 0!==options.end_with_newline&&options.end_with_newline,extra_liners="object"==typeof options.extra_liners&&options.extra_liners?options.extra_liners.concat():"string"==typeof options.extra_liners?options.extra_liners.split(","):"head,body,/html".split(","),eol=options.eol?options.eol:"auto",options.indent_with_tabs&&(indent_character="\t",indent_size=1),"auto"===eol&&(eol="\n",html_source&&lineBreak.test(html_source||"")&&(eol=html_source.match(lineBreak)[0])),eol=eol.replace(/\\r/,"\r").replace(/\\n/,"\n"),html_source=html_source.replace(allLineBreaks,"\n"),multi_parser=new Parser,multi_parser.printer(html_source,indent_character,indent_size,wrap_line_length,brace_style);;){var t=multi_parser.get_token();if(multi_parser.token_text=t[0],multi_parser.token_type=t[1],"TK_EOF"===multi_parser.token_type)break;switch(multi_parser.token_type){case"TK_TAG_START":multi_parser.print_newline(!1,multi_parser.output),multi_parser.print_token(multi_parser.token_text),multi_parser.indent_content&&(!multi_parser.indent_body_inner_html&&multi_parser.token_text.match(/<body(?:.*)>/)||!multi_parser.indent_head_inner_html&&multi_parser.token_text.match(/<head(?:.*)>/)||multi_parser.indent(),multi_parser.indent_content=!1),multi_parser.current_mode="CONTENT";break;case"TK_TAG_STYLE":case"TK_TAG_SCRIPT":multi_parser.print_newline(!1,multi_parser.output),multi_parser.print_token(multi_parser.token_text),multi_parser.current_mode="CONTENT";break;case"TK_TAG_END":if("TK_CONTENT"===multi_parser.last_token&&""===multi_parser.last_text){var tag_name=(multi_parser.token_text.match(/\w+/)||[])[0],tag_extracted_from_last_output=null;multi_parser.output.length&&(tag_extracted_from_last_output=multi_parser.output[multi_parser.output.length-1].match(/(?:<|{{#)\s*(\w+)/)),(null===tag_extracted_from_last_output||tag_extracted_from_last_output[1]!==tag_name&&!multi_parser.Utils.in_array(tag_extracted_from_last_output[1],unformatted))&&multi_parser.print_newline(!1,multi_parser.output)}multi_parser.print_token(multi_parser.token_text),multi_parser.current_mode="CONTENT";break;case"TK_TAG_SINGLE":var tag_check=multi_parser.token_text.match(/^\s*<([a-z-]+)/i);tag_check&&multi_parser.Utils.in_array(tag_check[1],unformatted)||multi_parser.print_newline(!1,multi_parser.output),multi_parser.print_token(multi_parser.token_text),multi_parser.current_mode="CONTENT";break;case"TK_TAG_HANDLEBARS_ELSE":for(var foundIfOnCurrentLine=!1,lastCheckedOutput=multi_parser.output.length-1;lastCheckedOutput>=0&&"\n"!==multi_parser.output[lastCheckedOutput];lastCheckedOutput--)if(multi_parser.output[lastCheckedOutput].match(/{{#if/)){foundIfOnCurrentLine=!0;break}foundIfOnCurrentLine||multi_parser.print_newline(!1,multi_parser.output),multi_parser.print_token(multi_parser.token_text),multi_parser.indent_content&&(multi_parser.indent(),multi_parser.indent_content=!1),multi_parser.current_mode="CONTENT";break;case"TK_TAG_HANDLEBARS_COMMENT":multi_parser.print_token(multi_parser.token_text),multi_parser.current_mode="TAG";break;case"TK_CONTENT":multi_parser.print_token(multi_parser.token_text),multi_parser.current_mode="TAG";break;case"TK_STYLE":case"TK_SCRIPT":if(""!==multi_parser.token_text){multi_parser.print_newline(!1,multi_parser.output);var _beautifier,text=multi_parser.token_text,script_indent_level=1;"TK_SCRIPT"===multi_parser.token_type?_beautifier="function"==typeof js_beautify&&js_beautify:"TK_STYLE"===multi_parser.token_type&&(_beautifier="function"==typeof css_beautify&&css_beautify),"keep"===options.indent_scripts?script_indent_level=0:"separate"===options.indent_scripts&&(script_indent_level=-multi_parser.indent_level);var indentation=multi_parser.get_full_indent(script_indent_level);if(_beautifier){var Child_options=function(){this.eol="\n"};Child_options.prototype=options;var child_options=new Child_options;text=_beautifier(text.replace(/^\s*/,indentation),child_options)}else{var white=text.match(/^\s*/)[0],_level=white.match(/[^\n\r]*$/)[0].split(multi_parser.indent_string).length-1,reindent=multi_parser.get_full_indent(script_indent_level-_level);text=text.replace(/^\s*/,indentation).replace(/\r\n|\r|\n/g,"\n"+reindent).replace(/\s+$/,"")}text&&(multi_parser.print_token_raw(text),multi_parser.print_newline(!0,multi_parser.output))}multi_parser.current_mode="TAG";break;default:""!==multi_parser.token_text&&multi_parser.print_token(multi_parser.token_text)}multi_parser.last_token=multi_parser.token_type,multi_parser.last_text=multi_parser.token_text}var sweet_code=multi_parser.output.join("").replace(/[\r\n\t ]+$/,"");return end_with_newline&&(sweet_code+="\n"),"\n"!==eol&&(sweet_code=sweet_code.replace(/[\n]/g,eol)),sweet_code}var lineBreak=/\r\n|[\n\r\u2028\u2029]/,allLineBreaks=new RegExp(lineBreak.source,"g");if("function"==typeof define&&define.amd)define(["require","./beautify","./beautify-css"],function(requireamd){var js_beautify=requireamd("./beautify"),css_beautify=requireamd("./beautify-css");return{html_beautify:function(html_source,options){return style_html(html_source,options,js_beautify.js_beautify,css_beautify.css_beautify)}}});else if("undefined"!=typeof exports){var js_beautify=require("./beautify.js"),css_beautify=require("./beautify-css.js");exports.html_beautify=function(html_source,options){return style_html(html_source,options,js_beautify.js_beautify,css_beautify.css_beautify)}}else"undefined"!=typeof window?window.html_beautify=function(html_source,options){return style_html(html_source,options,window.js_beautify,window.css_beautify)}:"undefined"!=typeof global&&(global.html_beautify=function(html_source,options){return style_html(html_source,options,global.js_beautify,global.css_beautify)})}();